USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_AwardBonusPointsToUser]    Script Date: 8/27/2013 2:27:15 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-07-76>
-- Description:	<award Bonus Point to user>
-- =============================================
CREATE PROCEDURE [dbo].[RP_AwardBonusPointsToUser]
	@userID int, @bonusPointsGiven money,
	@errorMessage varchar(max) OUTPUT 
AS
DECLARE @availableBonusPoints money, @recipientCanGetPoints int, @returnCode int = 1
BEGIN
	-- SET XACT_ABORT ON will cause the transaction to be non-committable
	-- when the constraint violation occurs. 
	SET XACT_ABORT ON;
	SET NOCOUNT ON;
	SELECT @errorMessage = 'completed sucessfully';
	SELECT @availableBonusPoints = (SELECT BonusPoints FROM [dbo].[RewardsProgram]);

	-- see if recipient is in program and not banned
	SELECT @recipientCanGetPoints = (Select UserID FROM [dbo].[RewardLegacyUser] WHERE IsBanned = 0 and IsInRewardsProgram = 1 and UserID = @UserID);

	IF @bonusPointsGiven >= @availableBonusPoints
		BEGIN
		SELECT @returnCode = 100;
		SELECT @errorMessage = 'Not enough bonus points';
		END;
	ELSE IF @recipientCanGetPoints IS NULL
		BEGIN
		SELECT @returnCode = 101;
		SELECT @errorMessage = 'User not in reward program';
		END;
	ELSE
		BEGIN
			BEGIN TRY
				BEGIN TRANSACTION;  --- put all update inserts between the TRANSACTION Begin and COMMIT with XACT_ABORT ON so If one fails they all do not commit
				-- insert the removal of points from sender
				UPDATE [dbo].[RewardsProgram] SET BonusPoints = (@availableBonusPoints - @bonusPointsGiven);
		INSERT INTO [dbo].[RewardTransaction] 
			(UserID
			,DateCreated
			,PointChange
			,Type)
		VALUES
			(@UserID
			,GETUTCDATE()
			,@bonusPointsGiven
			,4);
				COMMIT TRANSACTION;
			END TRY
			BEGIN CATCH
				ROLLBACK TRANSACTION;
				SELECT @returnCode = 900;
				SELECT @errorMessage = ERROR_MESSAGE();
			END CATCH;
	END;
	RETURN @returnCode
END

GO


